globals [traps-triggered]  ;; how many traps have been sprung?

to setup
  ca
  set traps-triggered 0
  ;; an untriggered mousetrap is light blue
  ask patches
    [ set pcolor blue + 3 ]
  ;; color the walls dark blue
  ask patches with [abs pxcor >= screen-edge-x - max-distance or
                    abs pycor >= screen-edge-y - max-distance]
    [ set pcolor blue - 3 ]  
  set-default-shape turtles "circle"
  ;; make the first ball
  cct 1
    [ set color white ]
  do-plots
end

to go
  if not any? turtles
    [ stop ]
  ask turtles
    [ ;; if we hit the wall or land on a triggered mousetrap,
      ;; then stop
      ifelse (pcolor = red) or (pcolor = blue - 3)
        [ die ]
        ;; triggered traps are red
        [ stamp red
          set traps-triggered traps-triggered + 1
          ;; send another ball flying off
          hatch 1
            [ move ]
          ;; also bounce ourselves
          move ] ]
  do-plots
end

to move  ;; turtle procedure
  rt random-float 360
  fd random-float max-distance
end

to do-plots
  set-current-plot "Traps triggered"
  plot traps-triggered
  set-current-plot "Balls in the air"
  plot count turtles
end

; *** NetLogo Model Copyright Notice ***
;
; This model was created as part of the project:
; PARTICIPATORY SIMULATIONS: NETWORK-BASED DESIGN FOR SYSTEMS LEARNING IN
; CLASSROOMS.  The project gratefully acknowledges the support of the
; National Science Foundation (REPP program) -- grant number REC #9814682.
;
; Copyright 2002 by Uri Wilensky.  Updated 2002.  All rights reserved.
;
; Permission to use, modify or redistribute this model is hereby granted,
; provided that both of the following requirements are followed:
; a) this copyright notice is included.
; b) this model will not be redistributed for profit without permission
;    from Uri Wilensky.
; Contact Uri Wilensky for appropriate licenses for redistribution for
; profit.
;
; To refer to this model in academic publications, please use:
; Wilensky, U. (2002).  NetLogo Mousetraps model.
; http://ccl.northwestern.edu/netlogo/models/Mousetraps.
; Center for Connected Learning and Computer-Based Modeling,
; Northwestern University, Evanston, IL.
;
; In other publications, please use:
; Copyright 1998 by Uri Wilensky.  All rights reserved.  See
; http://ccl.northwestern.edu/netlogo/models/Mousetraps
; for terms of use.
;
; *** End of NetLogo Model Copyright Notice ***
@#$#@#$#@
GRAPHICS-WINDOW
281
10
696
446
40
40
5.0
1
10
1
1
1
0

CC-WINDOW
5
466
705
561
Command Center

BUTTON
21
23
93
56
NIL
setup
NIL
1
T
OBSERVER
T
NIL

BUTTON
183
23
255
56
NIL
go
T
1
T
OBSERVER
T
NIL

PLOT
8
103
270
274
Traps triggered
NIL
NIL
0.0
10.0
0.0
100.0
true
false

PLOT
8
276
270
452
Balls in the air
NIL
NIL
0.0
10.0
0.0
100.0
true
false

BUTTON
98
23
179
56
go once
go
NIL
1
T
OBSERVER
T
NIL

SLIDER
21
61
255
94
max-distance
max-distance
0.0
10.0
5.0
0.5
1
NIL

@#$#@#$#@
WHAT IS IT?
-----------
Imagine a gymnasium full of mousetraps.  On each mousetrap is a ping pong ball.  Now throw a single ping pong ball into the middle of the room. The ball lands on a trap, the trap triggers, and a second ball flies into the air.  The first ball also bounces into the air again, so now there are two balls in the air.  Each of those two balls triggers another trap, so there's four balls in the air. And so on...

This experiment is a well-known metaphor for nuclear fission.  In nuclear fission, atoms of fissionable material such as uranium are the "mousetraps", and neutrons are the ping pong balls. 


HOW IT WORKS
------------
Light blue squares represent untriggered mousetraps.  Red squares represent triggered mousetraps.  Dark blue squares represent an empty area at the edge of the gymnasium.

When a ball lands on a light blue square, the square turns red, a new ball appears, and both balls travel a random distance in a random direction.


HOW TO USE IT
-------------
Press SETUP to set up all the mousetraps and suspend a single ping pong ball over the center.  Press GO to release the ping pong ball.

If you want to see the reaction progress in slow motion, use the GO ONCE button to advance a step at a time.

To vary the maximum distance a ping pong ball can travel when it is released or bounces, use the MAX-DISTANCE slider.


THINGS TO NOTICE
----------------
Sometimes the reaction fizzles out almost immediately.  Why do you think that happens?

Even if a sustained chain reaction occurs, not every mousetrap gets triggered.  Why?

What shape is the "Traps triggered" plot?  Why do you think it's shaped that way?

What shape is the "Balls in the air" plot?  Why do you think it's shaped that way?  

Suppose the gymnasium was infinitely large.  What would the two plots look like?  What kind of equation would produce such plots?


THINGS TO TRY
-------------
Play around with varying the MAX-DISTANCE slider.  How big does MAX-DISTANCE need to be in order to get a chain reaction every time?  Most of the time?


EXTENDING THE MODEL
-------------------
There are various ways in which this model could be more physically realistic.  For example:

- Currently both a released ball and a bouncing ball travel the same maximum distance, but in reality the mousetrap would likely send the released ball much farther.  Change the model so these different distances are controlled by two different sliders. 

- Currently the balls travel to their new positions instantly -- in reality it would take time proportional to the distance traveled.  (Does it make a difference if you take into account that the balls move in a parabola through the air, not a straight line?)  Change the model to take this into account.


NETLOGO FEATURES
----------------
Note the use of HATCH to cause the ping pong balls to "multiply".

When a turtle moves off the edge of the screen using the FORWARD or JUMP commands, it "wraps" around to the opposite edge.  We don't want that to happen in this model, so the dark blue patches are used to ensure that turtles never wrap.  But if MAX-DISTANCE is large, then a lot of the screen is wasted by all the dark blue.  The need for the dark blue can be eliminated by adding a check before jumping to see if the jump would take the turtle past the edge of the screen.  (Instead, we chose to keep the code as simple as possible.)


RELATED MODELS
--------------
Rumor Mill is very similar to this model in mechanism and results, even though the domain is completely different (people and rumors instead of mousetraps and ping pong balls).  (What other processes in nature or society does this model resemble...?)

Reactor X-Section and Reactor Top Down are two different views of nuclear fission happening inside a nuclear reactor.  They both include ways of limiting the rate of fission so the "mousetraps" don't all start triggering uncontrollably.


CREDITS AND REFERENCES
----------------------
This model is based on the "Mousetrap" demo included with the Swarm agent-based modeling toolkit (http://www.swarm.org/).  See http://acoma.santafe.edu/projects/swarm/examples/mousetrap/.  Note that this model and that demo differ in various details.

To refer to this NetLogo model in academic publications, please use: Wilensky, U. (2002).  NetLogo Mousetraps model.  http://ccl.northwestern.edu/netlogo/models/Mousetraps.  Center for Connected Learning and Computer-Based Modeling, Northwestern University, Evanston, IL.

In other publications, please use: Copyright 2002 by Uri Wilensky.  All rights reserved.  See http://ccl.northwestern.edu/netlogo/models/Mousetraps for terms of use.
@#$#@#$#@
default
true
0
Polygon -7566196 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7566196 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7566196 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7566196 true true 150 285 285 225 285 75 150 135
Polygon -7566196 true true 150 135 15 75 150 15 285 75
Polygon -7566196 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7566196 true true 96 182 108
Circle -7566196 true true 110 127 80
Circle -7566196 true true 110 75 80
Line -7566196 true 150 100 80 30
Line -7566196 true 150 100 220 30

butterfly
true
0
Polygon -7566196 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7566196 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7566196 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7566196 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7566196 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7566196 true true 47 195 58
Circle -7566196 true true 195 195 58

circle
false
0
Circle -7566196 true true 30 30 240

circle 2
false
0
Circle -7566196 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7566196 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7566196 true true 73 210 86 251 62 249 48 208
Polygon -7566196 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7566196 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7566196 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7566196 true true 60 15 75 300
Polygon -7566196 true true 90 150 270 90 90 30
Line -7566196 true 75 135 90 135
Line -7566196 true 75 45 90 45

flower
false
0
Polygon -11352576 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7566196 true true 85 132 38
Circle -7566196 true true 130 147 38
Circle -7566196 true true 192 85 38
Circle -7566196 true true 85 40 38
Circle -7566196 true true 177 40 38
Circle -7566196 true true 177 132 38
Circle -7566196 true true 70 85 38
Circle -7566196 true true 130 25 38
Circle -7566196 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -11352576 true false 189 233 219 188 249 173 279 188 234 218
Polygon -11352576 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7566196 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7566196 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7566196 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7566196 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7566196 true 150 0 150 300

pentagon
false
0
Polygon -7566196 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7566196 true true 110 5 80
Polygon -7566196 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7566196 true true 127 79 172 94
Polygon -7566196 true true 195 90 240 150 225 180 165 105
Polygon -7566196 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7566196 true true 135 90 165 300
Polygon -7566196 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7566196 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7566196 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7566196 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7566196 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7566196 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7566196 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7566196 true true 30 30 270 270

square 2
false
0
Rectangle -7566196 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7566196 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7566196 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7566196 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7566196 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7566196 true true 120 120 60

tree
false
0
Circle -7566196 true true 118 3 94
Rectangle -6524078 true false 120 195 180 300
Circle -7566196 true true 65 21 108
Circle -7566196 true true 116 41 127
Circle -7566196 true true 45 90 120
Circle -7566196 true true 104 74 152

triangle
false
0
Polygon -7566196 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7566196 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7566196 true true 4 45 195 187
Polygon -7566196 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7566196 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7566196 false true 24 174 42
Circle -7566196 false true 144 174 42
Circle -7566196 false true 234 174 42

turtle
true
0
Polygon -11352576 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -11352576 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -11352576 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -11352576 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -11352576 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7566196 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7566196 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7566196 true 150 285 150 15
Line -7566196 true 15 150 285 150
Circle -7566196 true true 120 120 60
Line -7566196 true 216 40 79 269
Line -7566196 true 40 84 269 221
Line -7566196 true 40 216 269 79
Line -7566196 true 84 40 221 269

x
false
0
Polygon -7566196 true true 270 75 225 30 30 225 75 270
Polygon -7566196 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 2.1beta4
@#$#@#$#@
setup
repeat 20 [ go ]
@#$#@#$#@
@#$#@#$#@
